﻿using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Graphic.Sample6
{
    public partial class FormMain : Form
    {
        [DllImport("user32.dll")]
        public static extern IntPtr GetDC(IntPtr hWnd);

        [Flags]
        public enum DrawFrameControlTypes
        {
            DFC_Button = 0x4,
            DFC_Caption = 0x1,
            DFC_Menu = 0x2,
            DFC_PopupMenu = 0x5,
            DFC_Scroll = 0x3
        }

        [Flags]
        public enum DrawFrameControlStates
        {
            Button_Check = 0,
            Button_RadioImage = 1,
            Button_RadioMask = 2,
            Button_Radio = 4,
            Button_State = 8,
            Button_Push = 0x10,
            Caption_Close = 0,
            Caption_Minimize = 1,
            Caption_Maximize = 2,
            Caption_Restore = 3,
            Caption_Help = 4,
            Menu_Arrow = 0,
            Menu_Check = 1,
            Menu_Bullet = 2,
            Menu_ArrowRight = 4,
            Scroll_Up = 0,
            Scroll_Down = 1,
            Scroll_Left = 2,
            Scroll_Right = 3,
            Scroll_ComboBox = 5,
            Scroll_SizeGrip = 8,
            Scroll_SizeGripRight = 0x10,
            Rectangle_AdjastRectangle = 0x2000,
            State_Inactive = 0x100,
            State_Pushed = 0x200,
            State_Checked = 0x400,
            State_Transparent = 0x800,
            State_Hot = 0x1000,
            State_Flat = 0x4000,
            State_Mono = 0x8000
        }

        [DllImport("user32.dll")]
        public static extern bool DrawFrameControl(IntPtr hDC, [In] ref Rectangle lpRect, DrawFrameControlTypes uType, DrawFrameControlStates uState);

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonDraw_Click(object sender, EventArgs e)
        {
            IntPtr hDC = GetDC(this.Handle);
            Rectangle lpRect = new Rectangle(10, 100, 40, 130);
            DrawFrameControl(hDC, ref lpRect, DrawFrameControlTypes.DFC_Button, DrawFrameControlStates.Button_Push | DrawFrameControlStates.State_Hot);
            lpRect = new Rectangle(50, 100, 80, 130);
            DrawFrameControl(hDC, ref lpRect, DrawFrameControlTypes.DFC_Caption, DrawFrameControlStates.Caption_Close);
            lpRect = new Rectangle(90, 100, 120, 130);
            DrawFrameControl(hDC, ref lpRect, DrawFrameControlTypes.DFC_Menu, DrawFrameControlStates.Menu_Check);
            lpRect = new Rectangle(130, 100, 160, 130);
            DrawFrameControl(hDC, ref lpRect, DrawFrameControlTypes.DFC_Scroll, DrawFrameControlStates.Scroll_Right);
        }
    }
}